
/*************************************************
****         VEGA - Trajectory header         ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __TRAJ
#  define  __TRAJ

#  ifndef  __GLOBDEF
#  include  "globdef.h"
#  endif

#  define  CarClose             PDBClose
#  define  CarSeekFrm           PDBSeekFrm

/**** Trajectory info ****/

typedef struct {
  char          FileName[VG_MAX_PATH];  /* Trajectory file name      */
  FILE          *FH;                    /* File handle               */
  float         *Energy;                /* Energy buffer             */
  VG_ULONG      EneFrames;              /* Energy frames             */
  float         EneMax, EneMin;         /* Value range               */
  VG_ULONG      EneStep;                /* Energy step               */
  VG_ULONG      ConvStep;               /* Energy step -> frame step */
  VG_ULONG      Format;                 /* Trajectory format         */
  VG_ULONG      SubFormat;              /* Trajectory subformat      */
  VG_ULONG      Frames;                 /* Number of frames          */
  VG_ULONG      FrmStep;                /* Frame step                */
  VG_ULONG      FrmCur;                 /* Current frame number      */
  VG_ULONG      FrmMax;                 /* Max. energy frame         */
  VG_ULONG      FrmMin;                 /* Lowest energy frame       */
  VG_ULONG      MolAtm;                 /* Number of atom            */
  float         Temp;                   /* Temperature               */
  VG_ULONG      StartTime;              /* Start time                */
  VG_ULONG      StartData;              /* File data pointer         */
  VG_ULONG      *SeekTab;               /* Fast seek table           */
  XYZ           *VectorBuf;             /* Vector buffer             */
  VG_BOOL       SwapEndian;             /* Swap endian flag          */
} TRJINFO;

/**** Global variables ****/

extern TRJINFO     TrjInfo;

#ifndef __VG_TYPES
#  include  "vgtypes.h"
#endif

#  ifdef __cplusplus
extern "C" {
#  endif

void       BioDockClose(TRJINFO *);
VG_BOOL    BioDockChangeDir(char *);
VG_BOOL    BioDockGetFileName(char *, char *);
VG_BOOL    BioDockOpen(char *, TRJINFO *);
VG_BOOL    BioDockReadFrm(TRJINFO *);
VG_BOOL    BioDockSeekFrm(TRJINFO *, VG_LONG, VG_LONG);
VG_BOOL    CarOpen(char *, TRJINFO *);
VG_BOOL    CarReadFrm(TRJINFO *, ATOMO *);
void       CsrClose(TRJINFO *);
VG_BOOL    CsrOpen(char *, TRJINFO *);
VG_BOOL    CsrReadFrm(TRJINFO *, ATOMO *);
VG_BOOL    CsrSeekFrm(TRJINFO *, VG_LONG, VG_LONG);
void       DCDClose(TRJINFO *);
VG_BOOL    DCDLoadEne(FILE *, TRJINFO *);
VG_BOOL    DCDLoadNamdOut(FILE *, TRJINFO *);
VG_BOOL    DCDOpen(char *, TRJINFO *);
VG_BOOL    DCDReadFrm(FILE *, ATOMO *);
VG_BOOL    DCDSeekFrm(TRJINFO *, VG_LONG, VG_LONG);
void       EscherClose(TRJINFO *);
VG_BOOL    EscherOpen(char *, TRJINFO *);
VG_BOOL    EscherReadFrm(TRJINFO *);
VG_BOOL    EscherSeekFrm(TRJINFO *, VG_LONG, VG_LONG);
FILE       *OpenPlot(char *, VG_UWORD *);
void       PDBClose(TRJINFO *);
VG_BOOL    PDBOpen(char *, TRJINFO *);
VG_BOOL    PDBReadFrm(TRJINFO *, ATOMO *);
VG_BOOL    PDBSeekFrm(TRJINFO *, VG_LONG, VG_LONG);
VG_BOOL    TrjAnalyzer(char *, ATOMO *, VG_ULONG, TRJPAR *);
float      *TrjCalc(TRJINFO *, TRJPAR *, ATOMO *, VG_ULONG);
void       TrjCalcEne(TRJINFO *);
void       TrjClose(TRJINFO *);
VG_BOOL    TrjOpen(char *, TRJINFO *, VG_UWORD);
VG_BOOL    TrjParser(TRJPAR *);
VG_BOOL    TrjPlotSave(char *, VG_ULONG, float *, VG_ULONG);
VG_BOOL    TrjReadFrm(TRJINFO *, VG_ULONG);
VG_BOOL    TrjSeekFrm(TRJINFO *, VG_LONG, VG_LONG);
void       XtcClose(TRJINFO *);
VG_BOOL    XtcLoadLog(FILE *, TRJINFO *);
VG_BOOL    XtcOpen(char *, TRJINFO *);
VG_BOOL    XtcReadFrm(TRJINFO *, ATOMO *);
VG_BOOL    XtcSeekFrm(TRJINFO *, VG_LONG, VG_LONG);

#  ifdef __cplusplus
}
#  endif
#endif

