
/*************************************************
****             VEGA - List engine           ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#include <malloc.h>

#include "globdef.h"
#include "globvar.h"
#include "vglist.h"


/**** Append an element in the list ****/

VG_LISTITEM *ListAppend(VG_LIST *Lh)
{
  VG_LISTITEM   *Li;

  if ((Li = (VG_LISTITEM *)Alloca(Lh -> ItemSize)) != NULL)
    ListBindAtEnd(Lh, Li);

  return Li;
}


/**** Bind the element at the end ****/

void ListBindAtEnd(VG_LIST *Lh, VG_LISTITEM *Li)
{
  if (Lh -> Beg) {
    Lh -> Last -> Next = Li;
    Li -> Prev         = Lh -> Last;
    Lh -> Last         = Li;
  } else Lh -> Beg = Lh -> Last = Li;
  ++Lh -> Num;
}


/**** Clear the list ****/

void ListClear(VG_LIST *Lh)
{
  register VG_LISTITEM          *Next1, *Next2;

  if (Lh) {
    for(Next1 = Lh -> Beg; Next1;) {
      Next2 = Next1 -> Next;
      FREE(Next1);
      Next1 = Next2;
    } /* End of for */
    FREE(Lh);
  }
}


/**** Get the molecule item ****/

VG_LISTITEM *ListGet(VG_LIST *Lh, VG_ULONG Idx)
{
  VG_LISTITEM          *Ret;

  if (Idx < Lh -> Num) {
    Ret = Lh -> Beg;
    while((Ret) && (Idx)) {
      Ret = Ret -> Next;
      --Idx;
    } /* End of while */
  } else Ret = NULL;

  return Ret;
}

/**** Create a new list ****/

VG_LIST *ListNew(VG_ULONG ItemSize)
{
  VG_LIST       *Lh;

  if ((Lh = (VG_LIST *)Alloca(sizeof(VG_LIST))) != NULL)
    Lh -> ItemSize = ItemSize;

  return Lh;
}


/**** Remove an item ****/

void ListRemove(VG_LIST *Lh, VG_LISTITEM *Li)
{
  if (Li -> Prev) {
    Li -> Prev -> Next = Li -> Next;
    if (Li -> Next) Li -> Next -> Prev = Li -> Prev;
  } else {
    Lh -> Beg = Li -> Next;
    if (Lh -> Beg) Lh -> Beg -> Prev = NULL;
  }
  if (Li == Lh -> Last) Lh -> Last = Li -> Prev; 

  --Lh -> Num;
  FREE(Li);
}
