
/*************************************************
****             VEGA - List engine           ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#ifndef __VGLIST_H
#define __VGLIST_H

/**** Dummy item list ****/

typedef struct __VgListItem {
  struct __VgListItem   *Next;
  struct __VgListItem   *Prev;
} VG_LISTITEM;

/**** List info ****/

typedef struct {
  VG_LISTITEM           *Beg;           /* Start of the list     */
  VG_LISTITEM           *Last;          /* Last item in the list */
  VG_ULONG              ItemSize;       /* Item size             */
  VG_ULONG              Num;            /* Number of items       */
} VG_LIST;


/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

VG_LISTITEM    *ListAppend(VG_LIST *);
void            ListBindAtEnd(VG_LIST *, VG_LISTITEM *);
void            ListClear(VG_LIST *);
VG_LISTITEM    *ListGet(VG_LIST *, VG_ULONG);
VG_LIST        *ListNew(VG_ULONG);
void            ListRemove(VG_LIST *, VG_LISTITEM *);

#  ifdef __cplusplus
}
#  endif
#endif
