
/*************************************************
****       VEGA - Volume calculation          ****
**** Copyright 1996-2003, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <string.h>
#include <math.h>

#include "globdef.h"
#include "globvar.h"
#include "formats.h"


/**** Find the box containing the molecule ****/

void CalcBox(register ATOMO *Atm, register float *VdwRad,
             register XYZ *Min, register XYZ *Max)
{
  Min -> x = Atm -> x - *VdwRad;
  Min -> y = Atm -> y - *VdwRad;
  Min -> z = Atm -> z - *VdwRad;
  Max -> x = Atm -> x + *VdwRad;
  Max -> y = Atm -> y + *VdwRad;
  Max -> z = Atm -> z + *VdwRad;

  do {
    if ((Atm -> x - *VdwRad) < Min -> x) Min -> x = Atm -> x - *VdwRad;
    if ((Atm -> y - *VdwRad) < Min -> y) Min -> y = Atm -> y - *VdwRad;
    if ((Atm -> z - *VdwRad) < Min -> z) Min -> z = Atm -> z - *VdwRad;
    if ((Atm -> x + *VdwRad) > Max -> x) Max -> x = Atm -> x + *VdwRad;
    if ((Atm -> y + *VdwRad) > Max -> y) Max -> y = Atm -> y + *VdwRad;
    if ((Atm -> z + *VdwRad) > Max -> z) Max -> z = Atm -> z + *VdwRad;
    ++VdwRad;
    Atm = Atm -> Ptr;
  } while(Atm);
}


/**** Calculate the molecular volume ****/

float CalcVolume(ATOMO *InizAtm, float *VdwRad, float Den,
                 XYZ *Min, XYZ *Max, VG_ULONG Flags)
{
  float                 Step;
  register ATOMO        *Atm;
  register float        X, Y, Z;
  register float        *Rad;

  register VG_ULONG     Dots = 0;

  Step = 1.0 / pow(Den, 1.0 / 3.0);     /* Linear density step */


  for(X = Min -> x; X <= Max -> x; X += Step) {
    for(Y = Min -> y; Y <= Max -> y; Y += Step) {
      for(Z = Min -> z; Z <= Max -> z; Z += Step) {
        Rad = VdwRad;
        for(Atm = InizAtm; Atm; Atm = Atm -> Ptr, ++Rad) {

          /**** Skip waters (for trajectory analysis) ****/

         if (((Flags & SRF_FLG_NOWAT) &&
#ifdef LITTLE_ENDIAN
             (Atm -> ResName.L == 0x00484F48)) ||
#else
             (Atm -> ResName.L == 0x484F4800)) ||
#endif
            ((Flags & SRF_FLG_SELONLY) && (!Atm -> Active))||
            (Atm -> Flags & VG_ATMF_CENTROID)) {
            continue;
          }

          if ((Quad(Atm -> x - X) + Quad(Atm -> y - Y) + Quad(Atm -> z - Z)) <= Quad(*Rad)) {
            ++Dots;
            break;
          }
        } /* End of Atm for */
      } /* End of Z for */
    } /* End of Y for */
  } /* End of X for */

  return (float)((float)Dots / Den);
}


