/*
 * $Id: xdrd.c,v 1.7 2002/02/28 10:49:35 spoel Exp $
 * 
 *                This source code is part of
 * 
 *                 G   R   O   M   A   C   S
 * 
 *          GROningen MAchine for Chemical Simulations
 * 
 *                        VERSION 3.1
 * Copyright (c) 1991-2001, University of Groningen, The Netherlands
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * If you want to redistribute modifications, please consider that
 * scientific software is very special. Version control is crucial -
 * bugs must be traceable. We will be happy to consider code for
 * inclusion in the official distribution, but derived work must not
 * be called official GROMACS. Details are found in the README & COPYING
 * files - if they are missing, get the official version at www.gromacs.org.
 * 
 * To help us fund GROMACS development, we humbly ask that you cite
 * the papers on the package - you can find them in the top README file.
 * 
 * For more info, check our website at http://www.gromacs.org
 * 
 * And Hey:
 * Gnomes, ROck Monsters And Chili Sauce
 */


#include "xdrf.h"

/**** Global variables ****/

extern int              xdrgloberr;


/**** XDR real ****/

int XDREXPORT xdr_real(XDR *xdrs, real *r)
{
#ifdef XDRDOUBLE
  float         f;
  int           ret;

  f = *r;
  ret = xdr_float(xdrs, &f);
  *r = f;

  return ret;
#else
  return xdr_float(xdrs, (float *)r);
#endif
}


/**** Un/compress a vector array ****/

int XDREXPORT xdr3drcoord(XDR *xdrs, real *fp, int *size, real *precision)
{
#ifdef XDRDOUBLE
  float                 *ffp, fprec;
  int                   i, ret;

  int                   isize = *size * 3;


  if (isize <= 0) return FALSE;

  if ((ffp = (float *)malloc(isize * sizeof(float))) == NULL) {
    xdrgloberr = XDR_ERR_OUTOFMEM;
    return FALSE;
  }


  for(i = 0; i < isize; i++) ffp[i] = fp[i];
  fprec = *precision;
  ret   = xdr3dfcoord(xdrs, ffp, size, &fprec);

  *precision = fprec;
  for(i = 0; i < isize; i++) fp[i] = ffp[i];
  free(ffp);

  return ret;
#else
  return xdr3dfcoord(xdrs, (float *)fp, size, (float *)precision);
#endif
}

