
/*************************************************
****       Read a Gromacs XTC trajectory      ****
**** Copyright 2002-2020, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <malloc.h>
#include "xdrf.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#if (defined WIN32 || defined _WIN32 || defined _WINDOWS || defined WINDOWS)
#  define  TEST_FILE  "..\\xtc_test.xtc"
#else
#  define  TEST_FILE  "../xtc_test.xtc"
#endif



/**** Definitions ****/

typedef struct {
  float         x, y, z;
} XYZ;


/**** Read the first frame in the gromacs trajectory ****/

int main(void)
{
  XDR           FH;
  int           k, Magic, TotAtm, Step;
  float         Time, ValF;
  XYZ           *Coord;

  if (xdropen(&FH, TEST_FILE, "r")) {

    /**** Read the header ****/

    if (xdr_int(&FH, &Magic) && (Magic == 1995)) {
      if (xdr_int(&FH, &TotAtm))  {
        printf("Atoms: %d\n", TotAtm);
        if (xdr_int(&FH, &Step))  {
          printf("Step:  %d\n", Step);
          if (xdr_float(&FH, &Time)) {
            printf("Time:  %f\n", Time);

            /**** Read the box ****/

            for(k = 0; (k < 9) && (xdr_float(&FH, &ValF)); ++k);

            if ((Coord = (XYZ *)malloc(TotAtm * sizeof(XYZ))) != NULL) {

              /**** Read the coordinates ****/

              xdr3dfcoord(&FH, (float *)Coord, &TotAtm, &ValF);

              /**** Print the coordinates ****/

              for(k = 0; k < TotAtm; ++k) {
                printf("%f %f %f\n", Coord[k].x, Coord[k].y, Coord[k].z);
              } /* End of for */
              free(Coord);
            }
          }
        }
      }
    } else fprintf(stderr, "Unknown file format\n");
    xdrclose(&FH);
  } else fprintf(stderr, "File not found\n");

  return 0;
}


