
/*************************************************
****      Write a Gromacs XTC trajectory      ****
**** Copyright 2002-2020, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <malloc.h>
#include "xdrf.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#if (defined WIN32 || defined _WIN32 || defined _WINDOWS || defined WINDOWS)
#  define  TEST_FILE  "..\\xtc_test2.xtc"
#else
#  define  TEST_FILE  "../xtc_test2.xtc"
#endif



/**** Definitions ****/

typedef struct {
  float         x, y, z;
} XYZ;


/**** Read the first frame in the gromacs trajectory ****/

int main(void)
{
  XDR           FH;
  int           k, Magic, TotAtm;
  float         ValF;
  XYZ           *Coord;

  TotAtm = 10;
  if ((Coord = (XYZ *)malloc(TotAtm * sizeof(XYZ))) == NULL) {
    fprintf(stderr, "Out of memory\n");
    return 0;
  }

  /**** Fill the coordinates ****/

  for(k = 0; k < TotAtm; ++k) {
    Coord[k].x = 0.1f * (float)k;
    Coord[k].y = Coord[k].x + 1.0f;
    Coord[k].z = Coord[k].x - 1.0f;
  } /* End of for (k) */

  if (xdropen(&FH, TEST_FILE, "w")) {
    Magic  = 1995;
    if ((xdr_int(&FH, &Magic )) &&
        (xdr_int(&FH, &TotAtm))) {

      /**** Write the PBC box ****/

      ValF = 0.0f;
      for(k = 0; (k < 9) && (xdr_float(&FH, &ValF)); ++k);

      /**** Write the step & the time ****/

      k = 0;
      if ((xdr_int(&FH, &k)) &&
          (xdr_int(&FH, &k))) {
        ValF = 1000.0f;
        xdr3dfcoord(&FH, (float *)Coord, &TotAtm, &ValF);
      }
    } else fprintf(stderr, "Unable to write the xtc header\n");
    xdrclose(&FH);
  } else fprintf(stderr, "Can't create the xtc file\n");

  free(Coord);

  return 0;
}


